# README Generation Prompt for Java Spring Boot Applications

## Overview
Generate a comprehensive, professional README.md for Java Spring Boot applications by using the provided template as a foundation and enhancing it with accurate information extracted from the actual codebase.

## Process

### Step 1: Analyze the Codebase
Before generating the README, perform deep analysis of the project structure:

1. **Read key files to understand the application:**
   - `src/main/java/**/Application.java` - Main application class
   - `build.gradle.kts` or `pom.xml` - Dependencies and build configuration
   - `src/main/resources/application.yml` - Configuration properties
   - Security configuration classes - Authentication/authorization setup
   - Service classes - Business logic and features
   - Controller classes - API endpoints
   - Database migration files - Schema and data setup
   - OpenAPI/Swagger specifications - API documentation

2. **Extract technical features from actual code:**
   - Authentication mechanisms (OAuth2, JWT, etc.)
   - Database technologies and patterns
   - API design approaches
   - Testing strategies
   - Logging and monitoring setup
   - Build and deployment configuration

3. **Identify business domain:**
   - Analyze entity/model classes
   - Review service method names and logic
   - Examine API endpoints for business functions
   - Check test cases for business scenarios

### Step 2: Use Template as Foundation
Use the template below as your structural foundation. The template comes from a proven enterprise application and includes:
- Proper organizational context (maintainers, contacts, documentation links)
- Professional structure and formatting
- Comprehensive technical coverage
- Multilingual support (Estonian + English)
- Enterprise-grade deployment and operational information

### Step 3: Enhancement Guidelines

**PRESERVE these elements from the template:**
- Organizational contact information structure (update with actual details)
- Estonian language sections and badges
- Professional formatting and anchor links
- Comprehensive section structure
- Enterprise context (JIRA, Confluence, service desk references)
- Deployment URLs structure
- Badge styling and external link patterns

**ENHANCE these elements with actual codebase data:**
- Business functions - extract from actual services and controllers
- Technical features - derive from actual configuration and code
- Technology map - extract from build files and dependencies
- Codebase structure - reflect actual project structure
- Development setup - use actual build commands and requirements
- API integration - reference actual OpenAPI specs and endpoints

**REPLACE placeholder content with:**
- Real application name and purpose
- Actual technical stack from build files
- Working setup commands that match the build system
- Real business functions derived from code analysis
- Accurate technical features with configuration examples
- Actual dependency versions and requirements

### Step 4: Quality Validation
Ensure the generated README:
- Contains no placeholder text or generic examples
- Includes working setup commands
- Accurately reflects the actual technical stack
- Preserves organizational context and professional structure
- Maintains proper Estonian capitalization (only first word and proper nouns capitalized)
- Includes real configuration examples where applicable

## README Template

```markdown
# Bookstore application

___

<a name="table-of-contents"></a>

## Table of contents

- **[Quick reference](#quick-reference-)**
- **[Description](#description-)**
- **[Business functions](#business-functions-)**
- **[Technical features](#technical-features-)**
- **[High-level architecture](#high-level-architecture-)**
- **[Technology map](#technology-map-)**
- **[Technical debt](#technical-debt-)**
- **[Related components](#related-components-)**
- **[Deployment](#deployment-)**
- **[Release strategy](#release-strategy-)**
- **[API integration](#api-integration-)**
- **[Branching workflow](#branching-workflow-)**
- **[Codebase structure](#codebase-structure-)**
- **[Development](#development-)**
- **[Testing](#testing-)**

___

<a name="quick-reference-"></a>

### Quick reference [↩](#table-of-contents)

- **Maintainers:** [MSK-74](https://servicedesk.smit.sise/browse/MSK-74)
- **Contact:** [transform@smit.ee](mailto:transform@smit.ee) or [#developers](https://chat.smit.sise/channel/developers)
- **Documentation:** [Confluence](https://wiki.smit.sise/display/BOOKSTORE)
- **Project management:** [JIRA](https://jira.smit.sise/projects/BOOKSTORE)
- **Service-level agreement:** [SRV-000](https://servicedesk.smit.sise/browse/SRV-000)
- **Disaster recovery plan:** [TEH-0000](https://servicedesk.smit.sise/browse/TEH-0000)

___

<a name="description-"></a>

### Description [↩](#table-of-contents)

![Estonian](https://shields.smit.sise/badge/language-Estonian-blue)

**Bookstore boot** ehk raamatupood on näidisrakendus, mis annab ülevaate, kuidas luua Spring Boot-Java rakendust.

Seda projekti kohendatakse regulaarselt, et see näidisrakendus vastaks meie organisatsiooni nõuetele ning parimatele tavadele.

___

<a name="business-functions-"></a>

### Business functions [↩](#table-of-contents)

![Estonian](https://shields.smit.sise/badge/language-Estonian-blue)

**Bookstore** ehk raamatupood pakub järgmisi põhifunktsioone:

1. **Raamatute haldamine**
    - Raamatute lisamine süsteemi
    - Olemasolevate raamatute info haldamine
    - Raamatute eemaldamine süsteemist

2. **Raamatute kuvamine**
    - Raamatute sirvimine
    - Raamatute otsing
    - Raamatute info vaatamine

___

<a name="technical-features-"></a>

### Technical features [↩](#table-of-contents)

**Bookstore** implements the following technical capabilities:

1. **OAuth2 Resource Server Security**
   - JWT-based authentication and authorization
   - Scope-based access control
   - Method-level security with @PreAuthorize annotations
   - Local JWT token validation using JWK
   - Integration with autentimine.smit.dev OAuth2 server
   - Comprehensive test security infrastructure

2. **Resilient Database Access**
   - Automated retry for transient database failures using Spring Retry.
   - Enhanced handling for PostgreSQL failover scenarios by identifying specific error codes (e.g., read-only errors on former primary) and triggering retries with potentially new connections.
   - Optimized connection pool settings (HikariCP) for better validation and connection cycling during failover.
   - Configurable retry attempts, backoff strategy, and timeouts.
   - Detailed logging for retry attempts and final failures.

3. **Comprehensive Audit Logging**
   - Structured audit events for all operations
   - Entity change tracking
   - User action attribution
   - ISO 8601 timestamp compliance
   - JSON-formatted audit trail
   - Example audit log:

   ```json
   {
     "correlationId": "550e8400-e29b-41d4-a716-446655440000",
     "time": "2023-04-04T12:34:56.123456Z",
     "application": {
       "name": "bookstore-service",
       "extraInfo": {
         "environment": "dev"
       }
     },
     "activity": {
       "action": "BOOK_UPDATED",
       "extraInfo": {
         "id": "123e4567-e89b-12d3-a456-426614174000",
         "oldTitle": "The Old Title",
         "newTitle": "The New Title",
         "oldAuthor": "Previous Author",
         "newAuthor": "Current Author"
       }
     },
     "actor": {
       "name": "system"
     },
     "client": {
       "id": "bookstore-app",
       "source": "INTERNAL"
     },
     "result": {
       "code": "SUCCESS",
       "message": "Operation completed successfully"
     }
   }
   ```

4. **Type-safe SQL Generation**
   - Compile-time SQL validation
   - Auto-generated database schema models
   - Fluent query API
   - Database-agnostic persistence layer

5. **Schema Migration**
   - Version-controlled database changes
   - SQL schema validation
   - Automated test data generation
   - Environment-specific migration contexts

6. **API-First Design**
   - OpenAPI specification as source of truth (`src/main/resources/swagger/openapi.yml`)
   - Auto-generated API models and interfaces
   - Type-safe request/response handling
   - Runtime documentation with Swagger UI

7. **Structured JSON Logging**
   - All application logs in JSON format
   - Consistent structure for easy parsing
   - Contextual information with MDC (request ID, user ID)
   - Log level configuration per package
   - Logback with Logstash encoder implementation
   - Separation of application and audit logs

___

<a name="high-level-architecture-"></a>

### High-level architecture [↩](#table-of-contents)

The application follows a clean layered architecture:

- **HTTP controller layer:** Handles HTTP requests and responses with input validation
- **Business layer:** Implements core business logic and orchestrates operations. Note: This layer currently includes data access logic using jOOQ (a jOOQ best practice).
- **Data access layer:** _(Database operations are currently managed within the business layer)_
- **Mapping layer:** Converts between API models and database entities

Key architectural decisions:

- API-first design using OpenAPI specification
- Clean separation of concerns between layers
- Type-safe database access with jOOQ
- Version controlled database schema with Flyway
- Comprehensive test coverage with JUnit 5

Infrastructure overview:

- Structured logging with JSON format for log aggregation
- Configuration uses environment variables and properties (e.g., for audit logging)
- Type-safe configuration management

___

<a name="technology-map-"></a>

### Technology map [↩](#table-of-contents)

- **Programming language:** Java 21
- **Framework:** Spring Boot 3.x
- **Database:** PostgreSQL 15
- **Database access:** jOOQ
- **Database change management:** Flyway
- **API design:** OpenAPI specification first design
- **Test framework:** JUnit with TestContainers
- **Build system:** Gradle with Kotlin DSL

### Core Libraries and Frameworks [↩](#table-of-contents)

The application is built using a carefully selected set of libraries and frameworks:

#### Backend Framework

- **Spring Boot:** Modern Java framework with support for virtual threads, AOT compilation, and powerful production-ready features
- **Spring Web:** REST API development with Spring MVC
- **Spring Security:** Authentication, authorization, and security features

#### Database and Persistence

- **jOOQ:** Type-safe SQL query generation and execution
- **Flyway:** Database schema version control
- **HikariCP:** High-performance JDBC connection pool
- **PostgreSQL:** Robust and feature-rich relational database

#### API and Documentation

- **SpringDoc OpenAPI:** API documentation and Swagger/ReDoc UI
- **Problem Details:** RFC 7807 error responses

#### Testing

- **JUnit:** Modern testing framework for Java
- **Mockito:** Mocking framework for unit tests
- **AssertJ:** Fluent assertions
- **TestContainers:** Container-based integration testing

#### Validation and Serialization

- **Jakarta Validation:** Bean validation
- **Jackson:** JSON serialization/deserialization

#### Observability

- **Spring Actuator:** Health checks, metrics, and monitoring
- **Structured Logging:** JSON-formatted logs for centralized logging

___

<a name="technical-debt-"></a>

### Technical debt [↩](#table-of-contents)

- **SonarQube:** [![Quality gate](https://sonar.smit.sise/api/project_badges/measure?project=ee.smit.msk74.teh0000.api&metric=alert_status&token=sqb_588901b9e8355b49b4b7106b99347554b4b305c9)](https://sonar.smit.sise/dashboard?id=ee.smit.msk74.teh0000.api)
- **Team estimation:** ![Low](https://shields.smit.sise/badge/Low-green.svg)

```text
No significant technical debt at this time. All security features including OAuth2 authentication and authorization have been implemented.
```

| Status | Description |
|:------:|:-----------|
| ![Low](https://shields.smit.sise/badge/Low-green.svg) | Technical debt is under control, maintained continuously, and **no extra development time** is necessary. The codebase is healthy, up-to-date, and aligns with development guidelines and best practices. Regular maintenance and refactoring are part of the standard development process. |
| ![Medium](https://shields.smit.sise/badge/Medium-yellow.svg) | Technical debt exists in moderate amounts. Resolving it requires **up to 20% of development time per week**, aiming **to reach low status in approximately 6 months**. Minor dependency version upgrades or codebase refactoring might be necessary. |
| ![High](https://shields.smit.sise/badge/High-red.svg) | Heavy technical debt is present, significantly hindering development velocity and posing risks to system integrity. Resolution requires substantial effort, including **extra sprints, to eventually reach medium status**. Critical issues may include unmaintained code, major dependency version upgrades, lack of tests, or performance bottlenecks. |
| ![Legacy](https://shields.smit.sise/badge/Legacy-white.svg) | The codebase is considered legacy and is scheduled to be replaced with a new solution. **No further development effort is planned** except for essential fixes. The focus is on migration to or development of the replacement system, which is documented under the related components. |

Various product support lifecycles can be tracked using [endoflife.date](https://endoflife.date).

___

<a name="related-components-"></a>

### Related components [↩](#table-of-contents)

- **Presentation layer:** [bookstore-frontend](https://source.smit.sise/projects/EXAMPLES/repos/bookstore-frontend)
- **Deployment plan:** [bookstore-deploy](https://source.smit.sise/projects/EXAMPLES/repos/bookstore-deploy)

___

<a name="deployment-"></a>

### Deployment [↩](#table-of-contents)

- **Development:** <https://bookstore.smit.dev>
- **Test:** <https://bookstore.smit.test>
- **Production:** <https://bookstore.smit.sise>

Application artifacts are bundled into a [Docker container](Dockerfile) that is based on a [distroless Java runtime](https://source.smit.sise/projects/DOCKERHUB/repos/java-distroless-runtime) image.

Database change management is performed via [Flyway](https://flywaydb.org/).

___

<a name="release-strategy-"></a>

### Release strategy [↩](#table-of-contents)

Given a version number `MAJOR.MINOR.PATCH`, increment the:

- `MAJOR` version when you make incompatible API changes
- `MINOR` version when you add functionality in a backward compatible manner
- `PATCH` version when you make backward compatible bug fixes

___

<a name="api-integration-"></a>

### API integration [↩](#table-of-contents)

- `/api/swagger/redoc/index.html` serves the specification in a human-readable document
- `/api/swagger/openapi.yml` serves the specification in a machine-readable document

All RESTful endpoints are documented using the OpenAPI specification. The API follows an API-first design approach, where:

- The primary OpenAPI specification is maintained in `src/main/resources/swagger/openapi.yml`
- The specification is used to generate server models and interfaces
- Runtime documentation is available via Swagger and ReDoc UIs

For API integration, external systems should use the programmatically accessible endpoint at `/api/swagger/openapi.yml`.

___

<a name="branching-workflow-"></a>

### Branching workflow [↩](#table-of-contents)

- `main` contains production-ready codebase and stores the official release history with Git tags
- `develop` serves as an integration branch for features
- `feature/*` used to develop new features

All commits to `main` and `develop` are done through pull requests with mandatory code reviews.

All commit messages must contain a ticket number.

___

<a name="codebase-structure-"></a>

### Codebase structure [↩](#table-of-contents)

```text
bookstore-boot-backend/
├── database/migration/        # Flyway SQL migrations
├── src/main/java/            # Application source code
├── src/test/java/            # Test source code
├── src/generated/            # Auto-generated code (jOOQ, OpenAPI)
├── build.gradle.kts          # Build configuration
├── docker-compose.yml        # Local development setup
└── docs/                     # Documentation
```

**Key directories:**
- `src/main/java/ee/smit/bookstore/`: Main application packages
- `database/migration/`: Versioned schema changes
- `src/generated/`: Auto-generated code (excluded from version control)

For detailed architectural information and design decisions, see the [component architecture documentation](docs/component-architecture.md).

___

<a name="development-"></a>

### Development [↩](#table-of-contents)

Familiarize yourself with [implementation guidelines and development best practices](docs/guidelines.md).

#### Prerequisites

- Java 21 JDK
- Gradle 8.5 or later
- Docker and Docker Compose
- Visual Studio Code with extensions:
  - Extension Pack for Java
  - Spring Boot Extension Pack
  - SonarLint
  - Gradle for Java

#### macOS with Colima

If you're using Colima on macOS, you'll need additional configuration for TestContainers to work properly:

Uncomment values from your .env variable regarding Docker and Colima.

Replace `$USER` with your username. This configuration ensures proper:

- Docker socket mapping for TestContainers
- Container-to-container communication
- Ryuk container cleanup functionality

#### Clone repository

```bash
git clone https://source.smit.sise/scm/examples/bookstore-boot-backend.git
cd bookstore-boot-backend
```

#### Configure environment variables

```bash
# Copy the example environment file
cp .env.example .env

# Edit the .env file with your specific settings
```

#### Initialize local PostgreSQL database

```bash
docker-compose up -d
gradlew flywayMigrate
```

#### Build and run the application

```bash
# Build the application
gradlew build

# Generate jOOQ and OpenAPI code when changing database or openapi file
gradlew generateJooq generateOpenApi

# Run the application
gradlew bootRun
```

#### Debug the application

The project includes VSCode launch configurations in `.vscode/launch.json`:

- **Debug Spring Boot Application:** Runs the application with development environment variables
- **Debug Unit Tests:** Runs all unit tests with the JUnit platform
- **Debug Current Test File:** Runs tests only in the currently open file
- **Debug Functional Tests:** Targets only the functional requirement tests
- **Debug Non-Functional Tests:** Targets only the non-functional requirement tests

To use these configurations:

1. Open the Debug panel in VSCode (Ctrl+Shift+D or Cmd+Shift+D)
2. Select the configuration you want from the dropdown
3. Click the green play button or press F5

___

<a name="testing-"></a>

### Testing [↩](#table-of-contents)

The project uses a comprehensive testing approach:

#### Unit Tests

- Test individual components in isolation
- Use Mockito for mocking dependencies
- Follow AAA (Arrange-Act-Assert) pattern
- Focus on business logic validation

#### Integration Tests

- Test component interactions
- Use TestContainers for database testing
- Verify database migrations
- Test API endpoints, including request/response formats and error handling
- Verify OpenAPI documentation

#### Security Tests

- Static code analysis (SAST) using Sonar
- Software Composition Analysis (SCA) and security scanning using JFrog

#### Test Coverage Requirements

- Minimum 80% line coverage
- 100% coverage for critical paths
- No coverage for generated code
- Regular coverage reports
```

## Expected Output Quality

The generated README should achieve:
- **Organizational Context:** 9/10 (preserves enterprise structure)
- **Technical Accuracy:** 9/10 (based on actual codebase analysis) 
- **Professional Structure:** 10/10 (uses proven template)
- **Completeness:** 9/10 (comprehensive coverage)
- **Estonian Content:** 10/10 (preserves multilingual sections)

## Critical Success Factors

1. **Analyze first, write second** - Deep codebase analysis before generation
2. **Template-based enhancement** - Use the provided structure as foundation
3. **Real data over placeholders** - Extract actual technical details
4. **Preserve organizational context** - Maintain enterprise-grade structure
5. **Working setup instructions** - Include commands that actually work
6. **Accurate technical stack** - Reflect the real technologies used
